/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.rendering.entities;

import com.badlogic.gdx.math.Vector2;
import technology.rocketjump.undermount.assets.entities.model.SpriteDescriptor;
import technology.rocketjump.undermount.entities.model.Entity;

public class EntityPartRenderStep {
    public static final float PIXELS_PER_TILE = 64.0f;
    private final Vector2 absolutePosition;
    private final Vector2 baseEntityPosition;
    private final SpriteDescriptor spriteDescriptor;
    private final Entity entity;
    private Entity otherEntity;

    public EntityPartRenderStep(SpriteDescriptor spriteDescriptor, Vector2 parentWorldPosition, Vector2 baseEntityPosition, Entity entity) {
        this.entity = entity;
        this.absolutePosition = spriteDescriptor != null ? parentWorldPosition.add(spriteDescriptor.getOffsetPixels().cpy().scl(0.015625f)) : parentWorldPosition.cpy();
        this.spriteDescriptor = spriteDescriptor;
        this.baseEntityPosition = baseEntityPosition;
    }

    public Vector2 getAbsolutePosition() {
        return this.absolutePosition;
    }

    public SpriteDescriptor getSpriteDescriptor() {
        return this.spriteDescriptor;
    }

    public Vector2 getBaseEntityPosition() {
        return this.baseEntityPosition;
    }

    public boolean isAnotherEntity() {
        return this.otherEntity != null;
    }

    public Entity getOtherEntity() {
        return this.otherEntity;
    }

    public void setOtherEntity(Entity otherEntity) {
        this.otherEntity = otherEntity;
    }

    public Entity getEntity() {
        return this.entity;
    }
}

